<div>
  <div class="mb-4 flex-col items-center gap-5 sm:flex-row md:flex md:justify-between lg:mr-4">
    <h3 class="mb-4 text-lg font-semibold leading-tight text-gray-800 dark:text-gray-200 md:mb-0">
      {{ __('Employee Data') }}
    </h3>
    <x-button wire:click="showCreating">
      <x-heroicon-o-plus class="mr-2 h-4 w-4" /> {{ __('Add Employee') }}
    </x-button>
  </div>
  <div class="mb-1 text-sm dark:text-white">{{ __('Filter') }}:</div>
  <div class="mb-4 grid grid-cols-1 sm:grid-cols-3 gap-4 lg:flex lg:flex-wrap lg:gap-5">
    <div class="w-full lg:w-48">
        <x-tom-select id="division" wire:model.live="division" placeholder="{{ __('Select Division') }}"
            :options="App\Models\Division::all()->map(fn($d) => ['id' => $d->id, 'name' => $d->name])" />
    </div>
    <div class="w-full lg:w-48">
        <x-tom-select id="jobTitle" wire:model.live="jobTitle" placeholder="{{ __('Select Job Title') }}"
            :options="App\Models\JobTitle::all()->map(fn($j) => ['id' => $j->id, 'name' => $j->name])" />
    </div>
    <div class="w-full lg:w-48">
        <x-tom-select id="education" wire:model.live="education" placeholder="{{ __('Last Education') }}"
            :options="App\Models\Education::all()->map(fn($e) => ['id' => $e->id, 'name' => $e->name])" />
    </div>
    <div class="col-span-1 sm:col-span-3 lg:col-span-1 lg:w-auto flex flex-col sm:flex-row items-stretch sm:items-center gap-2">
      <x-input type="text" class="w-full lg:w-72" name="search" id="search" wire:model.live.debounce.300ms="search"
        placeholder="{{ __('Search') }}" />
      {{-- <div class="flex gap-2">
        <x-button class="flex-1 sm:flex-none justify-center sm:w-32" type="button" wire:click="$refresh" wire:loading.attr="disabled">
          {{ __('Search') }}
        </x-button>
        @if ($search)
          <x-secondary-button class="flex-1 sm:flex-none justify-center sm:w-32" type="button" wire:click="$set('search', '')"
            wire:loading.attr="disabled">
            {{ __('Reset') }}
          </x-secondary-button>
        @endif
      </div> --}}
    </div>
  </div>

  <!-- Mobile Card View -->
  <div class="grid grid-cols-1 gap-4 sm:hidden">
    @foreach ($users as $user)
      @php
        $wireClick = "wire:click=show('$user->id')";
      @endphp
      <div class="card p-4" wire:key="mobile-{{ $user->id }}">
          <div class="flex items-start gap-4 mb-4">
              <div class="shrink-0" {{ $wireClick }}>
                  <img class="h-12 w-12 rounded-full object-cover" src="{{ $user->profile_photo_url }}" alt="{{ $user->name }}" />
              </div>
              <div class="flex-1 min-w-0" {{ $wireClick }}>
                  <h4 class="text-base font-semibold text-gray-900 dark:text-white truncate">
                      {{ $user->name }}
                  </h4>
                  <p class="text-xs text-gray-500 dark:text-gray-400 truncate">
                      {{ $user->jobTitle ? json_decode($user->jobTitle)->name : '-' }}
                  </p>
                  <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200 mt-1">
                      {{ $user->division ? json_decode($user->division)->name : '-' }}
                  </span>
              </div>
          </div>
          
          <div class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-4" {{ $wireClick }}>
              <div class="flex justify-between">
                  <span class="text-gray-500">NIP</span>
                  <span class="font-medium">{{ $user->nip }}</span>
              </div>
              <div class="flex justify-between">
                  <span class="text-gray-500">Email</span>
                  <span class="font-medium truncate ml-2">{{ $user->email }}</span>
              </div>
              <div class="flex justify-between">
                  <span class="text-gray-500">Phone</span>
                  <span class="font-medium">{{ $user->phone }}</span>
              </div>
          </div>

          <div class="grid grid-cols-2 gap-3 pt-3 border-t border-gray-100 dark:border-gray-700">
              <x-secondary-button wire:click="edit('{{ $user->id }}')" class="justify-center">
                  <x-heroicon-o-pencil class="mr-2 h-4 w-4" />
                  Edit
              </x-secondary-button>
              <x-danger-button wire:click="confirmDeletion('{{ $user->id }}', '{{ $user->name }}')" class="justify-center">
                  <x-heroicon-o-trash class="mr-2 h-4 w-4" />
                  Delete
              </x-danger-button>
          </div>
      </div>
    @endforeach
  </div>

  <!-- Desktop Table View -->
  <div class="hidden sm:block overflow-x-scroll">
    <table class="w-full divide-y divide-gray-200 dark:divide-gray-700">
      <thead class="bg-gray-50 dark:bg-gray-900">
        <tr>
          <th scope="col"
            class="relative px-2 py-2 text-center text-xs font-medium text-gray-500 dark:text-gray-300">
            No.
          </th>
          <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300">
            {{ __('Name') }}
          </th>
          <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300">
            {{ __('NIP') }}
          </th>
          <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300">
            {{ __('Email') }}
          </th>
          <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300">
            {{ __('Phone Number') }}
          </th>
          <th scope="col"
            class="hidden px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 sm:table-cell">
            {{ __('City') }}
          </th>
          <th scope="col" class="relative px-6 py-3">
            <span class="sr-only">Actions</span>
          </th>
        </tr>
      </thead>
      <tbody class="divide-y divide-gray-200 bg-white dark:divide-gray-700 dark:bg-gray-800">
        @php
          $class = 'cursor-pointer group-hover:bg-gray-100 dark:group-hover:bg-gray-700';
        @endphp
        @foreach ($users as $user)
          @php
            $wireClick = "wire:click=show('$user->id')";
          @endphp
          <tr wire:key="{{ $user->id }}" class="group">
            <td class="{{ $class }} p-2 text-center text-sm font-medium text-gray-900 dark:text-white"
              {{ $wireClick }}>
              {{ $loop->iteration }}
            </td>
            <td class="{{ $class }} px-6 py-4 text-sm font-medium text-gray-900 dark:text-white"
              {{ $wireClick }}>
              {{ $user->name }}
            </td>
            <td class="{{ $class }} px-6 py-4 text-sm font-medium text-gray-900 dark:text-white"
              {{ $wireClick }}>
              {{ $user->nip }}
            </td>
            <td class="{{ $class }} px-6 py-4 text-sm font-medium text-gray-900 dark:text-white"
              {{ $wireClick }}>
              {{ $user->email }}
            </td>
            <td class="{{ $class }} px-6 py-4 text-sm font-medium text-gray-900 dark:text-white"
              {{ $wireClick }}>
              {{ $user->phone }}
            </td>
            <td
              class="{{ $class }} hidden px-6 py-4 text-sm font-medium text-gray-900 dark:text-white sm:table-cell"
              {{ $wireClick }}>
              {{ $user->city }}
            </td>
            <td class="relative flex justify-end gap-2 px-6 py-4">
              <x-button wire:click="edit('{{ $user->id }}')" class="px-2 py-1">
                <x-heroicon-o-pencil class="w-4 h-4" />
              </x-button>
              <x-danger-button wire:click="confirmDeletion('{{ $user->id }}', '{{ $user->name }}')" class="px-2 py-1">
                <x-heroicon-o-trash class="w-4 h-4" />
              </x-danger-button>
            </td>
          </tr>
        @endforeach
      </tbody>
    </table>
  </div>
  <div class="mt-3">
    {{ $users->links() }}
  </div>

  <x-confirmation-modal wire:model="confirmingDeletion">
    <x-slot name="title">
      {{ __('Delete Employee') }}
    </x-slot>

    <x-slot name="content">
      {{ __('Are you sure you want to delete') }} <b>{{ $deleteName }}</b>?
    </x-slot>

    <x-slot name="footer">
      <x-secondary-button wire:click="$toggle('confirmingDeletion')" wire:loading.attr="disabled">
        {{ __('Cancel') }}
      </x-secondary-button>

      <x-danger-button class="ml-2" wire:click="delete" wire:loading.attr="disabled">
        {{ __('Confirm') }}
      </x-danger-button>
    </x-slot>
  </x-confirmation-modal>

  <x-dialog-modal wire:model="creating">
    <x-slot name="title">
      {{ __('New Employee') }}
    </x-slot>

    <form wire:submit="create">
      <x-slot name="content">
        @if (Laravel\Jetstream\Jetstream::managesProfilePhotos())
          <div x-data="{ photoName: null, photoPreview: null }" class="col-span-6 sm:col-span-4">
            <!-- Profile Photo File Input -->
            <input type="file" id="photo_create" class="hidden" wire:model.live="form.photo" x-ref="photo" accept="image/*"
              x-on:change="
                                    photoName = $refs.photo.files[0].name;
                                    const reader = new FileReader();
                                    reader.onload = (e) => {
                                        photoPreview = e.target.result;
                                    };
                                    reader.readAsDataURL($refs.photo.files[0]);
                            " />

            <x-label for="photo_create" value="{{ __('Photo') }}" />

            <!-- Current Profile Photo -->
            <div class="mt-2 h-20 w-20 rounded-full outline outline-gray-400" x-show="! photoPreview">
            </div>

            <!-- New Profile Photo Preview -->
            <div class="mt-2" x-show="photoPreview" style="display: none;">
              <span class="block h-20 w-20 rounded-full bg-cover bg-center bg-no-repeat"
                x-bind:style="'background-image: url(\'' + photoPreview + '\');'">
              </span>
            </div>

            <x-secondary-button class="me-2 mt-2" type="button" x-on:click.prevent="$refs.photo.click()">
              {{ __('Select A New Photo') }}
            </x-secondary-button>

            @if ($form->user?->profile_photo_path)
              <x-secondary-button type="button" class="mt-2" wire:click="deleteProfilePhoto">
                {{ __('Remove Photo') }}
              </x-secondary-button>
            @endif

            @error('form.photo')
              <x-input-error for="form.photo" message="{{ $message }}" class="mt-2" />
            @enderror
          </div>
        @endif
        <div class="mt-4">
          <x-label for="create_name">{{ __('Employee Name') }}</x-label>
          <x-input id="create_name" class="mt-1 block w-full" type="text" wire:model="form.name" autocomplete="off" />
          @error('form.name')
            <x-input-error for="form.name" class="mt-2" message="{{ $message }}" />
          @enderror
        </div>
        <div class="mt-4 flex flex-col gap-4 sm:flex-row sm:gap-3">
          <div class="w-full">
            <x-label for="create_email">{{ __('Email') }}</x-label>
            <x-input id="create_email" class="mt-1 block w-full" type="email" wire:model="form.email"
              placeholder="example@example.com" required autocomplete="off" />
            @error('form.email')
              <x-input-error for="form.email" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
          <div class="w-full">
            <x-label for="create_nip">NIP</x-label>
            <x-input id="create_nip" class="mt-1 block w-full" type="text" wire:model="form.nip"
              placeholder="12345678" required autocomplete="off" />
            @error('form.nip')
              <x-input-error for="form.nip" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
        </div>
        <div class="mt-4 flex flex-col gap-4 sm:flex-row sm:gap-3">
          <div class="w-full">
            <x-label for="create_password">{{ __('Password') }}</x-label>
            <x-input id="create_password" class="mt-1 block w-full" type="password" wire:model="form.password"
              placeholder="New Password" autocomplete="new-password" />
            <p class="text-sm dark:text-gray-400">{{ __('Default password') }}: <b>password</b></p>
            @error('form.password')
              <x-input-error for="form.password" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
        </div>
        <div class="mt-4 flex flex-col gap-4 sm:flex-row sm:gap-3">
          <div class="w-full">
            <span class="block font-medium text-sm text-gray-700 dark:text-gray-300">{{ __('Gender') }}</span>
            <div class="my-3 flex flex-row gap-5">
              <div class="flex items-center">
                <input type="radio" id="create_gender_male" wire:model="form.gender" value="male" />
                <x-label for="create_gender_male" class="ml-2">{{ __('Male') }}</x-label>
              </div>
              <div class="flex items-center">
                <input type="radio" id="create_gender_female" wire:model="form.gender" value="female" />
                <x-label for="create_gender_female" class="ml-2">{{ __('Female') }}</x-label>
              </div>
            </div>
            @error('form.gender')
              <x-input-error for="form.gender" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
          <div class="w-full">
            <x-label for="create_phone">{{ __('Phone') }}</x-label>
            <x-input id="create_phone" class="mt-1 block w-full" type="number" wire:model="form.phone"
              placeholder="+628123456789" autocomplete="off" />
            @error('form.phone')
              <x-input-error for="form.phone" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
        </div>
        <div class="mt-4 flex flex-col gap-4 sm:flex-row sm:gap-3">
          <div class="w-full">
            <x-label for="create_birth_date">{{ __('Birth Date') }}</x-label>
            <x-input id="create_birth_date" class="mt-1 block w-full" type="date" wire:model="form.birth_date" autocomplete="off" />
            @error('form.birth_date')
              <x-input-error for="form.birth_date" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
          <div class="w-full">
            <x-label for="create_birth_place">{{ __('Birth Place') }}</x-label>
            <x-input id="create_birth_place" class="mt-1 block w-full" type="text" wire:model="form.birth_place"
              placeholder="Jakarta" autocomplete="off" />
            @error('form.birth_place')
              <x-input-error for="form.birth_place" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
        </div>
        <div class="mt-4 flex flex-col gap-4 sm:flex-row sm:gap-3">
          <div class="w-full">
            <x-label for="create_city">{{ __('City') }}</x-label>
            <x-input id="create_city" class="mt-1 block w-full" type="text" wire:model="form.city"
              placeholder="Domisili" autocomplete="off" />
            @error('form.city')
              <x-input-error for="form.city" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
          <div class="w-full">
            <x-label for="create_address">{{ __('Address') }}</x-label>
            <x-input id="create_address" class="mt-1 block w-full" type="text" wire:model="form.address"
              placeholder="Jl. Jend. Sudirman" autocomplete="off" />
            @error('form.address')
              <x-input-error for="form.address" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
        </div>
        <div class="mt-4">
          <x-label for="create_division" value="{{ __('Division') }}" />
          <div class="mt-1 block w-full">
            <x-tom-select id="create_division" wire:model.live="form.division_id" placeholder="{{ __('Select Division') }}"
                :options="App\Models\Division::all()->map(fn($d) => ['id' => $d->id, 'name' => $d->name])" />
          </div>
          @error('form.division_id')
            <x-input-error for="form.division_id" class="mt-2" message="{{ $message }}" />
          @enderror
        </div>
        <div class="mt-4">
          <x-label for="create_jobTitle" value="{{ __('Job Title') }}" />
          <div class="mt-1 block w-full" wire:key="create-job-title-wrapper-{{ $form->division_id ?? 'all' }}">
            <x-tom-select id="create_jobTitle" wire:model.live="form.job_title_id" placeholder="{{ __('Select Job Title') }}"
                :options="$availableJobTitles->map(fn($j) => ['id' => $j->id, 'name' => $j->name])" />
          </div>
          @error('form.job_title_id')
            <x-input-error for="form.job_title_id" class="mt-2" message="{{ $message }}" />
          @enderror
        </div>
        <div class="mt-4">
          <x-label for="create_education" value="{{ __('Last Education') }}" />
          <div class="mt-1 block w-full">
            <x-tom-select id="create_education" wire:model="form.education_id" placeholder="{{ __('Select Education') }}"
                :options="App\Models\Education::all()->map(fn($e) => ['id' => $e->id, 'name' => $e->name])" />
          </div>
          @error('form.education_id')
            <x-input-error for="form.education_id" class="mt-2" message="{{ $message }}" />
          @enderror
        </div>
      </x-slot>

      <x-slot name="footer">
        <x-secondary-button wire:click="$toggle('creating')" wire:loading.attr="disabled">
          {{ __('Cancel') }}
        </x-secondary-button>

        <x-button class="ml-2" wire:click="create" wire:loading.attr="disabled" wire:target="form.photo">
          {{ __('Confirm') }}
        </x-button>
      </x-slot>
    </form>
  </x-dialog-modal>

  <x-dialog-modal wire:model="editing">
    <x-slot name="title">
      {{ __('Edit Employee') }}
    </x-slot>

    <form wire:submit.prevent="update" id="user-edit">
      <x-slot name="content">
        @if (Laravel\Jetstream\Jetstream::managesProfilePhotos())
          <div x-data="{ photoName: null, photoPreview: null }" class="col-span-6 sm:col-span-4">
            <!-- Profile Photo File Input -->
            <input type="file" id="photo_edit" class="hidden" wire:model.live="form.photo" x-ref="photo" accept="image/*"
              x-on:change="
                                    photoName = $refs.photo.files[0].name;
                                    const reader = new FileReader();
                                    reader.onload = (e) => {
                                        photoPreview = e.target.result;
                                    };
                                    reader.readAsDataURL($refs.photo.files[0]);
                            " />

            <x-label for="photo_edit" value="{{ __('Photo') }}" />

            <div class="mt-2" x-show="! photoPreview">
              <img src="{{ $form->user?->profile_photo_url }}" alt="{{ $form->user?->name }}"
                class="h-20 w-20 rounded-full object-cover">
            </div>

            <!-- New Profile Photo Preview -->
            <div class="mt-2" x-show="photoPreview" style="display: none;">
              <span class="block h-20 w-20 rounded-full bg-cover bg-center bg-no-repeat"
                x-bind:style="'background-image: url(\'' + photoPreview + '\');'">
              </span>
            </div>

            <x-secondary-button class="me-2 mt-2" type="button" x-on:click.prevent="$refs.photo.click()">
              {{ __('Select A New Photo') }}
            </x-secondary-button>

            @if ($form->user?->profile_photo_path)
              <x-secondary-button type="button" class="mt-2" wire:click="deleteProfilePhoto">
                {{ __('Remove Photo') }}
              </x-secondary-button>
            @endif

            @error('form.photo')
              <x-input-error for="form.photo" message="{{ $message }}" class="mt-2" />
            @enderror
          </div>
        @endif
        <div class="mt-4">
          <x-label for="edit_name">{{ __('Employee Name') }}</x-label>
          <x-input id="edit_name" class="mt-1 block w-full" type="text" wire:model="form.name" autocomplete="off" />
          @error('form.name')
            <x-input-error for="form.name" class="mt-2" message="{{ $message }}" />
          @enderror
        </div>
        <div class="mt-4 flex flex-col gap-4 sm:flex-row sm:gap-3">
          <div class="w-full">
            <x-label for="edit_email">{{ __('Email') }}</x-label>
            <x-input id="edit_email" class="mt-1 block w-full" type="email" wire:model="form.email"
              placeholder="example@example.com" required autocomplete="off" />
            @error('form.email')
              <x-input-error for="form.email" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
          <div class="w-full">
            <x-label for="edit_nip">NIP</x-label>
            <x-input id="edit_nip" class="mt-1 block w-full" type="text" wire:model="form.nip"
              placeholder="12345678" required autocomplete="off" />
            @error('form.nip')
              <x-input-error for="form.nip" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
        </div>
        <div class="mt-4 flex flex-col gap-4 sm:flex-row sm:gap-3">
          <div class="w-full">
            <x-label for="edit_password">{{ __('Password') }}</x-label>
            <x-input id="edit_password" class="mt-1 block w-full" type="password" wire:model="form.password"
              placeholder="New Password" autocomplete="new-password" />
            @error('form.password')
              <x-input-error for="form.password" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
        </div>
        <div class="mt-4 flex flex-col gap-4 sm:flex-row sm:gap-3">
          <div class="w-full">
            <span class="block font-medium text-sm text-gray-700 dark:text-gray-300">{{ __('Gender') }}</span>
            <div class="my-3 flex flex-row gap-5">
              <div class="flex items-center">
                <input type="radio" id="edit_gender_male" wire:model="form.gender" value="male" />
                <x-label for="edit_gender_male" class="ml-2">{{ __('Male') }}</x-label>
              </div>
              <div class="flex items-center">
                <input type="radio" id="edit_gender_female" wire:model="form.gender" value="female" />
                <x-label for="edit_gender_female" class="ml-2">{{ __('Female') }}</x-label>
              </div>
            </div>
            @error('form.gender')
              <x-input-error for="form.gender" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
          <div class="w-full">
            <x-label for="edit_phone">{{ __('Phone') }}</x-label>
            <x-input id="edit_phone" class="mt-1 block w-full" type="text" wire:model="form.phone"
              placeholder="+628123456789" autocomplete="off" />
            @error('form.phone')
              <x-input-error for="form.phone" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
        </div>
        <div class="mt-4 flex flex-col gap-4 sm:flex-row sm:gap-3">
          <div class="w-full">
            <x-label for="edit_birth_date">{{ __('Birth Date') }}</x-label>
            <x-input id="edit_birth_date" class="mt-1 block w-full" type="date" wire:model="form.birth_date" autocomplete="off" />
            @error('form.birth_date')
              <x-input-error for="form.birth_date" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
          <div class="w-full">
            <x-label for="edit_birth_place">{{ __('Birth Place') }}</x-label>
            <x-input id="edit_birth_place" class="mt-1 block w-full" type="text" wire:model="form.birth_place"
              placeholder="Jakarta" autocomplete="off" />
            @error('form.birth_place')
              <x-input-error for="form.birth_place" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
        </div>
        <div class="mt-4 flex flex-col gap-4 sm:flex-row sm:gap-3">
          <div class="w-full">
            <x-label for="edit_city">{{ __('City') }}</x-label>
            <x-input id="edit_city" class="mt-1 block w-full" type="text" wire:model="form.city"
              placeholder="Domisili" autocomplete="off" />
            @error('form.city')
              <x-input-error for="form.city" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
          <div class="w-full">
            <x-label for="edit_address">{{ __('Address') }}</x-label>
            <x-input id="edit_address" class="mt-1 block w-full" type="text" wire:model="form.address"
              placeholder="Jl. Jend. Sudirman" autocomplete="off" />
            @error('form.address')
              <x-input-error for="form.address" class="mt-2" message="{{ $message }}" />
            @enderror
          </div>
        </div>
        <div class="mt-4">
          <x-label for="edit_division" value="{{ __('Division') }}" />
          <div class="mt-1 block w-full">
            <x-tom-select id="edit_division" wire:model.live="form.division_id" placeholder="{{ __('Select Division') }}"
                :options="App\Models\Division::all()->map(fn($d) => ['id' => $d->id, 'name' => $d->name])" />
          </div>
          @error('form.division_id')
            <x-input-error for="form.division_id" class="mt-2" message="{{ $message }}" />
          @enderror
        </div>
        <div class="mt-4">
          <x-label for="edit_jobTitle" value="{{ __('Job Title') }}" />
          <div class="mt-1 block w-full" wire:key="edit-job-title-wrapper-{{ $form->division_id ?? 'all' }}">
            <x-tom-select id="edit_jobTitle" wire:model.live="form.job_title_id" placeholder="{{ __('Select Job Title') }}"
                :options="$availableJobTitles->map(fn($j) => ['id' => $j->id, 'name' => $j->name])" />
          </div>
          @error('form.job_title_id')
            <x-input-error for="form.job_title_id" class="mt-2" message="{{ $message }}" />
          @enderror
        </div>
        <div class="mt-4">
          <x-label for="edit_education" value="{{ __('Last Education') }}" />
          <div class="mt-1 block w-full">
            <x-tom-select id="edit_education" wire:model="form.education_id" placeholder="{{ __('Select Education') }}"
                :options="App\Models\Education::all()->map(fn($e) => ['id' => $e->id, 'name' => $e->name])" />
          </div>
          @error('form.education_id')
            <x-input-error for="form.education_id" class="mt-2" message="{{ $message }}" />
          @enderror
        </div>
      </x-slot>

      <x-slot name="footer">
        <x-secondary-button wire:click="$toggle('editing')" wire:loading.attr="disabled">
          {{ __('Cancel') }}
        </x-secondary-button>

        <x-button class="ml-2" wire:click="update" wire:loading.attr="disabled" wire:target="form.photo">
          {{ __('Confirm') }}
        </x-button>
      </x-slot>
    </form>
  </x-dialog-modal>

  <x-modal wire:model="showDetail">
    @if ($form->user)
      @php
        $division = $form->user->division ? json_decode($form->user->division)->name : '-';
        $jobTitle = $form->user->jobTitle ? json_decode($form->user->jobTitle)->name : '-';
        $education = $form->user->education ? json_decode($form->user->education)->name : '-';
      @endphp
      <div class="px-6 py-4">
        <div class="my-4 flex items-center justify-center">
          <img class="h-32 w-32 rounded-full object-cover" src="{{ $user->profile_photo_url }}"
            alt="{{ $user->name }}" />
        </div>

        <div class="text-center text-lg font-medium text-gray-900 dark:text-gray-100">
          {{ $form->user->name }}
        </div>

        <div class="mt-4 text-sm text-gray-600 dark:text-gray-400">
          <div class="mt-4">
            <x-label value="NIP" />
            <p>{{ $form->user->nip }}</p>
          </div>
          <div class="mt-4">
            <x-label value="{{ __('Email') }}" />
            <p>{{ $form->user->email }}</p>
          </div>
          <div class="mt-4">
            <x-label value="{{ __('Phone') }}" />
            <p>{{ $form->user->phone }}</p>
          </div>
          <div class="mt-4">
            <x-label value="{{ __('Gender') }}" />
            <p>{{ __($form->user->gender) }}</p>
          </div>
          <div class="mt-4">
            <x-label value="{{ __('Birth Date') }}" />
            @if ($form->user->birth_date)
              <p>{{ \Illuminate\Support\Carbon::parse($form->user->birth_date)->format('D d M Y') }}</p>
            @else
              <p>-</p>
            @endif
          </div>
          <div class="mt-4">
            <x-label value="{{ __('Birth Place') }}" />
            <p>{{ $form->user->birth_place ?? '-' }}</p>
          </div>
          <div class="mt-4">
            <x-label value="{{ __('Address') }}" />
            @if (empty($form->user->address))
              <p>-</p>
            @else
              <p>{{ $form->user->address }}</p>
            @endif
          </div>
          <div class="mt-4">
            <x-label value="{{ __('City') }}" />
            @if (empty($form->user->city))
              <p>-</p>
            @else
              <p>{{ $form->user->city }}</p>
            @endif
          </div>
          <div class="mt-4">
            <x-label value="{{ __('Job Title') }}" />
            <p>{{ $jobTitle }}</p>
          </div>
          <div class="mt-4">
            <x-label value="{{ __('Division') }}" />
            <p>{{ $division }}</p>
          </div>
          <div class="mt-4">
            <x-label value="{{ __('Last Education') }}" />
            <p>{{ $education }}</p>
          </div>
        </div>
      </div>
    @endif
  </x-modal>
</div>
