<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
   /**
    * Run the migrations.
    */
   public function up(): void
   {
      Schema::create('geolocation_logs', function (Blueprint $table) {
         $table->id();
         $table->bigInteger('user_id')->nullable();
         $table->decimal('latitude', 10, 8);
         $table->decimal('longitude', 11, 8);
         $table->string('action')->default('attendance');
         $table->string('ip_address')->nullable();
         $table->text('user_agent')->nullable();
         $table->json('metadata')->nullable();
         $table->timestamps();
         $table->index(['user_id', 'created_at']);
         $table->index(['created_at']);
      });
   }

   /**
    * Reverse the migrations.
    */
   public function down(): void
   {
      Schema::dropIfExists('geolocation_logs');
   }
};
